using System;
using System.Data;
using System.Data.SqlClient;
using System.Windows.Forms;

public class CMain : Form
{
  DataGrid dataGrid;

  public static string BuildConnectionString(string serverName, 
                                             string dbName, 
                                             string userName, 
                                             string passWd)
  {
    return String.Format(  
      @"Server={0};Database={1};User ID={2};Pwd={3};Connect Timeout=15", 
        serverName, dbName, userName, passWd);
  }

  public CMain()
  {
    // inicjuj DataGrid
    dataGrid = new DataGrid();
    dataGrid.Dock = DockStyle.Fill;
    this.Controls.Add( dataGrid );

    try
    {
      SqlConnection sqlConn = new SqlConnection();
      	
      sqlConn.ConnectionString = 
        BuildConnectionString( "(local)", "sqlTEST", "sa", String.Empty );

      sqlConn.Open();

      // inicjuj DataSet przy pomocy SqlDataAdapter
      SqlDataAdapter adapter = new SqlDataAdapter( 
        "SELECT * FROM T_STUDENT", sqlConn );
      // automatycznie twrz polecenia do 
      // wstawiania, modyfikacji i usuwania danych
      new SqlCommandBuilder( adapter );

      DataSet dataSet = new DataSet( "Dane" );
      // napenij DataSet przez IDataAdapter
      adapter.Fill( dataSet );

      // powi DataGrid i DataSet 
      dataGrid.SetDataBinding( dataSet, "Table" );
      
      // zamknij poczenie
      sqlConn.Close();
    }
    catch ( Exception ex )
    {
      Console.WriteLine( ex.Message );
    } 
  }

  public static void Main()
  {
    Application.Run( new CMain() );
  }  
}
